<?php

    // USER CONFIGURATION FILE
    // Only modify the settings below according to your needs
    // For detailed guides visit: http://www.monstaftp.com/guides
    // Additional settings are available in "settings.json"

    // =====================================================
    // GENERAL SETTINGS
    // =====================================================

    // Path to the settings.json file (usually no need to change)
    $configPathSettings = dirname(__FILE__) . "/settings.json";

    // Server timezone (examples: "UTC", "America/New_York", "Europe/London")
    $configTimeZone = "UTC";

    // Temporary directory for file operations (leave empty for system default)
    $configTempDir = "";

    // Maximum file upload size (examples: "100M", "1G", "2048M")
    $configMaxFileSize = "2G";

    // Upload chunk size ("default" or specific size like "10M")
    $configChunkUploadSize = "default";

    // Maximum execution time for operations in seconds
    $configMaxExecutionTimeSeconds = 1800;

    // =====================================================
    // AUTHENTICATION SETTINGS
    // =====================================================

    // Enable SSH agent authentication (true/false)
    $configSSHAgentAuthEnabled = false;

    // Enable SSH key file authentication (true/false)
    $configSSHKeyAuthEnabled = false;

    // =====================================================
    // INTERFACE SETTINGS
    // =====================================================

    // Page title shown in browser tab
    $configPageTitle = "Monsta FTP";

    // =====================================================
    // SECURITY SETTINGS
    // =====================================================

    // Maximum failed login attempts before blocking
    $configMaxLoginFailures = 3;

    // Minutes to wait before allowing login attempts again
    $configLoginFailuresResetTimeMinutes = 5;

    // =====================================================
    // LOGGING SETTINGS
    // =====================================================

    // Custom action log file path (null to disable)
    $configMftpActionLogPath = null;

    // Custom action log function name (null to disable)
    $configMftpActionLogFunction = null;

    // Enable logging to system syslog (true/false)
    $configLogToSyslog = false;

    // Syslog facility (LOG_USER, LOG_LOCAL0, etc.)
    $configMftpSyslogFacility = LOG_USER;

    // Enable logging to a file (true/false)
    $configLogToFile = true;

    // Path to log file (null to disable)
    $configMftpLogFilePath = dirname(__FILE__) . '/../application/logs/mftp_debug.log';

    // Log level threshold (LOG_DEBUG, LOG_INFO, LOG_WARNING, LOG_ERR)
    $configMftpLogLevelThreshold = LOG_DEBUG;

    // =====================================================
    // UPLOAD SETTINGS
    // =====================================================

    // Maximum concurrent uploads (increased to allow more simultaneous uploads)
    $configMaxConcurrentUploads = 100;

    // Upload session timeout in seconds (recommended: 7200 = 2 hours)
    $configUploadSessionTimeout = 7200;

    // Number of retry attempts for failed upload operations (recommended: 3)
    $configUploadRetryAttempts = 3;

    // Delay between retry attempts in microseconds (100000 = 100ms)
    $configUploadRetryDelay = 100000;

    // Upload chunk size in bytes (1048576 = 1MB)
    $configUploadChunkSize = 1048576;

    // Enable fallback file mechanisms for uploads (true/false)
    $configUploadFallbackEnabled = true;

    // Extend session timeout for upload operations (true/false)
    $configUploadSessionExtend = true;

    // Update session activity during uploads (true/false)
    $configUploadSessionActivityUpdate = true;

    // Enable enhanced error handling and logging (true/false)
    $configUploadEnhancedErrorHandling = true;

    // Enable debug logging for uploads (true/false)
    $configUploadDebugLogging = true;

    // Use file locking to prevent race conditions (true/false)
    $configUploadUseFileLocking = true;

    // Lock timeout in seconds (recommended: 30)
    $configUploadLockTimeout = 30;

    // Socket timeout in seconds for FTP operations (recommended: 300 = 5 minutes)
    $configUploadSocketTimeout = 300;

    // Automatic cleanup of old upload files (true/false)
    $configUploadAutoCleanup = true;

    // Clean up files older than this many seconds (3600 = 1 hour)
    $configUploadCleanupAge = 3600;

    // =====================================================
    // UPDATE SETTINGS
    // =====================================================

    // Disable automatic version checking (true/false)
    $configDisableLatestVersionCheck = false; 