<?php
/**
 * Test script for error logging functionality
 * 
 * This script tests the error logging system to ensure it's working correctly.
 * Access it via: http://your-domain/mftp/application/logs/test_error_logging.php
 */

// Security check
$allowedIPs = ['127.0.0.1', '::1'];
$password = 'monsta_test_2025'; // Change this password!

if (!in_array($_SERVER['REMOTE_ADDR'], $allowedIPs) && 
    (!isset($_GET['password']) || $_GET['password'] !== $password)) {
    http_response_code(403);
    die('Access denied. Use ?password=monsta_test_2025');
}

// Initialize error logging
require_once(dirname(__FILE__) . '/../api/error_logging_config.php');

?>
<!DOCTYPE html>
<html>
<head>
    <title>MonstaFTP Error Logging Test</title>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1 { color: #333; border-bottom: 2px solid #007cba; padding-bottom: 10px; }
        .test-section { margin: 20px 0; padding: 15px; border: 1px solid #dee2e6; border-radius: 4px; }
        .test-btn { background: #007cba; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer; margin: 5px; }
        .test-btn:hover { background: #0056b3; }
        .success { background: #d4edda; border-color: #c3e6cb; color: #155724; }
        .error { background: #f8d7da; border-color: #f5c6cb; color: #721c24; }
        .info { background: #d1ecf1; border-color: #bee5eb; color: #0c5460; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🧪 MonstaFTP Error Logging Test</h1>
        
        <div class="test-section info">
            <h3>📋 Test Status</h3>
            <p>This page tests the error logging functionality. Check the log files after running tests.</p>
            <p><strong>Log Files Location:</strong> <code>application/logs/</code></p>
        </div>
        
        <?php if (isset($_GET['test'])): ?>
            <div class="test-section">
                <h3>🔬 Test Results</h3>
                
                <?php
                $test = $_GET['test'];
                
                switch ($test) {
                    case 'info':
                        mftpLogError('Test INFO message', ['test' => 'info_logging'], 'INFO');
                        echo '<div class="success">✅ INFO message logged successfully</div>';
                        break;
                        
                    case 'warning':
                        mftpLogError('Test WARNING message', ['test' => 'warning_logging'], 'WARNING');
                        echo '<div class="success">✅ WARNING message logged successfully</div>';
                        break;
                        
                    case 'error':
                        mftpLogError('Test ERROR message', ['test' => 'error_logging'], 'ERROR');
                        echo '<div class="success">✅ ERROR message logged successfully</div>';
                        break;
                        
                    case 'performance':
                        $start = microtime(true);
                        usleep(100000); // Sleep for 100ms
                        $duration = microtime(true) - $start;
                        mftpLogPerformance('TEST_OPERATION', $duration, ['test' => 'performance_logging']);
                        echo '<div class="success">✅ Performance log entry created (duration: ' . round($duration * 1000, 2) . 'ms)</div>';
                        break;
                        
                    case 'timeout':
                        mftpLogTimeout('TEST_TIMEOUT', 5.5, ['test' => 'timeout_logging']);
                        echo '<div class="success">✅ Timeout log entry created</div>';
                        break;
                        
                    case 'exception':
                        try {
                            throw new Exception('Test exception for logging');
                        } catch (Exception $e) {
                            mftpLogError('Test exception caught', [
                                'exception' => get_class($e),
                                'message' => $e->getMessage(),
                                'file' => $e->getFile(),
                                'line' => $e->getLine()
                            ], 'EXCEPTION');
                            echo '<div class="success">✅ Exception logged successfully</div>';
                        }
                        break;
                        
                    case 'php_error':
                        // Trigger a PHP warning
                        $undefined = $undefinedVariable;
                        echo '<div class="success">✅ PHP warning triggered and logged</div>';
                        break;
                        
                    default:
                        echo '<div class="error">❌ Unknown test type</div>';
                }
                ?>
            </div>
        <?php endif; ?>
        
        <div class="test-section">
            <h3>🧪 Available Tests</h3>
            <p>Click the buttons below to test different logging scenarios:</p>
            
            <a href="?test=info&password=monsta_test_2025" class="test-btn">Test INFO Logging</a>
            <a href="?test=warning&password=monsta_test_2025" class="test-btn">Test WARNING Logging</a>
            <a href="?test=error&password=monsta_test_2025" class="test-btn">Test ERROR Logging</a>
            <a href="?test=performance&password=monsta_test_2025" class="test-btn">Test Performance Logging</a>
            <a href="?test=timeout&password=monsta_test_2025" class="test-btn">Test Timeout Logging</a>
            <a href="?test=exception&password=monsta_test_2025" class="test-btn">Test Exception Logging</a>
            <a href="?test=php_error&password=monsta_test_2025" class="test-btn">Test PHP Error Logging</a>
        </div>
        
        <div class="test-section info">
            <h3>📊 How to Monitor Logs</h3>
            <ul>
                <li><strong>View Logs:</strong> <a href="monitor_logs.php?password=monsta_logs_2025" target="_blank">Open Log Monitor</a></li>
                <li><strong>Command Line:</strong> <code>tail -f application/logs/php_errors.log</code></li>
                <li><strong>Timeout Issues:</strong> <code>tail -f application/logs/timeout_issues.log</code></li>
                <li><strong>Performance:</strong> <code>tail -f application/logs/performance.log</code></li>
            </ul>
        </div>
        
        <div class="test-section">
            <h3>🔧 Configuration</h3>
            <p><strong>Error Log Path:</strong> <code><?php echo MFTP_ERROR_LOG_PATH; ?></code></p>
            <p><strong>Timeout Log Path:</strong> <code><?php echo MFTP_TIMEOUT_LOG_PATH; ?></code></p>
            <p><strong>Performance Log Path:</strong> <code><?php echo MFTP_PERFORMANCE_LOG_PATH; ?></code></p>
            <p><strong>PHP Error Reporting:</strong> <code><?php echo error_reporting(); ?></code></p>
            <p><strong>Memory Limit:</strong> <code><?php echo ini_get('memory_limit'); ?></code></p>
            <p><strong>Max Execution Time:</strong> <code><?php echo ini_get('max_execution_time'); ?> seconds</code></p>
        </div>
    </div>
</body>
</html>

