<?php
/**
 * Log Monitor for MonstaFTP
 * 
 * This script helps monitor the various log files for debugging timeout issues.
 * Access it via: http://your-domain/mftp/application/logs/monitor_logs.php
 */

// Security check - only allow access from localhost or with password
$allowedIPs = ['127.0.0.1', '::1'];
$password = 'monsta_logs_2025'; // Change this password!

if (!in_array($_SERVER['REMOTE_ADDR'], $allowedIPs) && 
    (!isset($_GET['password']) || $_GET['password'] !== $password)) {
    http_response_code(403);
    die('Access denied. Use ?password=monsta_logs_2025');
}

$logDir = __DIR__;
$logFiles = [
    'php_errors.log' => 'PHP Errors & Warnings',
    'timeout_issues.log' => 'Timeout Issues',
    'performance.log' => 'Performance Metrics'
];

?>
<!DOCTYPE html>
<html>
<head>
    <title>MonstaFTP Log Monitor</title>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        h1 { color: #333; border-bottom: 2px solid #007cba; padding-bottom: 10px; }
        .log-section { margin: 20px 0; }
        .log-header { background: #007cba; color: white; padding: 10px; border-radius: 4px 4px 0 0; }
        .log-content { background: #f8f9fa; border: 1px solid #dee2e6; border-top: none; padding: 15px; font-family: monospace; font-size: 12px; white-space: pre-wrap; max-height: 400px; overflow-y: auto; }
        .refresh-btn { background: #28a745; color: white; padding: 10px 20px; border: none; border-radius: 4px; cursor: pointer; margin: 10px 0; }
        .refresh-btn:hover { background: #218838; }
        .stats { display: flex; gap: 20px; margin: 20px 0; }
        .stat-box { background: #e9ecef; padding: 15px; border-radius: 4px; flex: 1; text-align: center; }
        .stat-number { font-size: 24px; font-weight: bold; color: #007cba; }
        .stat-label { color: #6c757d; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 MonstaFTP Log Monitor</h1>
        
        <div class="stats">
            <div class="stat-box">
                <div class="stat-number"><?php echo count($logFiles); ?></div>
                <div class="stat-label">Log Files</div>
            </div>
            <div class="stat-box">
                <div class="stat-number"><?php echo date('H:i:s'); ?></div>
                <div class="stat-label">Last Updated</div>
            </div>
            <div class="stat-box">
                <div class="stat-number"><?php echo ini_get('max_execution_time'); ?>s</div>
                <div class="stat-label">PHP Timeout</div>
            </div>
        </div>
        
        <button class="refresh-btn" onclick="location.reload()">🔄 Refresh Logs</button>
        
        <?php foreach ($logFiles as $filename => $title): ?>
            <div class="log-section">
                <div class="log-header">
                    📄 <?php echo $title; ?> (<?php echo $filename; ?>)
                    <?php 
                    $filepath = $logDir . '/' . $filename;
                    if (file_exists($filepath)) {
                        $size = filesize($filepath);
                        $modified = date('Y-m-d H:i:s', filemtime($filepath));
                        echo " - " . formatBytes($size) . " - Modified: $modified";
                    }
                    ?>
                </div>
                <div class="log-content">
<?php
$filepath = $logDir . '/' . $filename;
if (file_exists($filepath)) {
    $content = file_get_contents($filepath);
    if (empty($content)) {
        echo "No entries yet.";
    } else {
        // Show last 50 lines
        $lines = explode("\n", $content);
        $lastLines = array_slice($lines, -50);
        echo htmlspecialchars(implode("\n", $lastLines));
    }
} else {
    echo "Log file not found.";
}
?>
                </div>
            </div>
        <?php endforeach; ?>
        
        <div style="margin-top: 30px; padding: 15px; background: #d1ecf1; border-radius: 4px;">
            <h3>💡 Tips for Debugging Timeouts:</h3>
            <ul>
                <li><strong>Performance Log:</strong> Look for operations taking >5 seconds</li>
                <li><strong>Timeout Log:</strong> Check for specific operations that are timing out</li>
                <li><strong>PHP Errors:</strong> Look for memory issues or fatal errors</li>
                <li><strong>Memory Usage:</strong> High memory deltas may indicate memory leaks</li>
                <li><strong>Slow Operations:</strong> FTP operations, file transfers, or database queries</li>
            </ul>
        </div>
    </div>
</body>
</html>

<?php
function formatBytes($bytes, $precision = 2) {
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    
    for ($i = 0; $bytes > 1024 && $i < count($units) - 1; $i++) {
        $bytes /= 1024;
    }
    
    return round($bytes, $precision) . ' ' . $units[$i];
}
?>

