angular.module('MonstaFTP').run(['$templateCache', function($templateCache) {$templateCache.put('application/frontend/templates/body-files.html','<div id="files" ng-controller="FileBrowserController as vm" ng-mousedown="vm.handleBodyClick($event)" oncontextmenu="return false"><ng-include src="\'application/frontend/templates/body-order-by.html\'"></ng-include><div class="dropdown" ondragstart="return false;"><button data-toggle="dropdown" style="display: none" id="extras-dropdown-button"></button><ul class="dropdown-menu" id="extras-dropdown"><li ng-click="vm.initiateMakeItem(\'FILE\')" ng-show="vm.allowFileCreation &amp;&amp; !vm.contextMenuItemHidden(\'new-file\')"><a href="#"><i class="fa fa-file-o fa-fw"></i> {{ \'NEW_FILE_DEFERRED_ACTION\'|translate }} </a></li><li ng-click="vm.initiateMakeItem(\'FOLDER\')" ng-show="!vm.contextMenuItemHidden(\'new-folder\')"><a href="#"><i class="fa fa-folder-o fa-fw"></i> {{ \'NEW_FOLDER_DEFERRED_ACTION\'|translate }} </a></li><li role="separator" class="divider" ng-show="(!vm.contextMenuItemHidden(\'new-folder\') || (!vm.contextMenuItemHidden(\'new-file\') &amp;&amp; vm.allowFileCreation)) &amp;&amp; !vm.contextMenuItemHidden(\'paste\')"></li><li data-name="paste" ng-click="vm.performPaste()" ng-show="!vm.contextMenuItemHidden(\'paste\')"><a href="#" ng-class="{inactive: !hasPasteSource}" ><i class="fa fa-clipboard fa-fw"></i> {{ \'PASTE_ACTION\'|translate }} </a></li></ul></div><table><thead class="mobile-hide"><tr><td class="spacer"></td><td class="icon" ng-hide="vm.browserColumnHidden(\'icon\')"></td><td class="file" ng-hide="vm.browserColumnHidden(\'name\')"><monsta-reorder vm="vm" sort-name="NAME" sort-identifier="name"></monsta-reorder></td><td class="spacer"></td><td class="size" ng-hide="vm.browserColumnHidden(\'size\')"><monsta-reorder vm="vm" sort-name="SIZE" sort-identifier="size"></monsta-reorder></td><td class="modified" ng-hide="vm.browserColumnHidden(\'modified\')"><monsta-reorder vm="vm" sort-name="CHANGED" sort-identifier="modified"></monsta-reorder></td><td class="spacer"></td><td class="permissions" ng-hide="vm.browserColumnHidden(\'permissions\')"> {{ "PERMISSIONS"|translate }} </td><td class="other" ng-hide="vm.browserColumnHidden(\'properties\')"></td><td class="spacer"></td></tr></thead><tbody><tr ng-if="vm.uiOperationFactory.currentDirectory != null && vm.uiOperationFactory.currentDirectory != \'\' && vm.uiOperationFactory.currentDirectory != \'/\'"><td class="spacer"></td><td class="icon" ng-click="vm.navigateUpOneLevel()" ng-hide="vm.browserColumnHidden(\'icon\')"><i class="fa fa-level-up fa-fw"></i></td><td class="file" ng-hide="vm.browserColumnHidden(\'name\')"><span class="up" ng-click="vm.navigateUpOneLevel()">..</span></td><td class="spacer"></td><td class="size" ng-hide="vm.browserColumnHidden(\'size\')"></td><td class="modified mobile-hide" ng-hide="vm.browserColumnHidden(\'modified\')"></td><td class="spacer mobile-hide"></td><td class="permissions mobile-hide" ng-hide="vm.browserColumnHidden(\'permissions\')"></td><td class="other" ng-hide="vm.browserColumnHidden(\'properties\')"></td><td class="spacer mobile-hide"></td></tr><tr ng-repeat="item in directoryList" ng-class-odd="\'tr-odd\'" ng-class-even="\'tr-even\'" ng-class="{\'ui-selected\': selectedItems.indexOf($index) != -1}" class="context-catcher-tr" ng-mousedown="vm.rowMouseDown($event)" ng-mousemove="vm.rowMouseMove($event, $index)" ng-mouseup="vm.rowMouseUp($index)" ng-mouseleave="vm.rowMouseLeave($event)" data-index="{{ $index }}"><td class="spacer"></td><td class="icon" ng-hide="vm.browserColumnHidden(\'icon\')"><i class="fa {{ item|icon }} fa-fw"></i></td><td class="file" ng-hide="vm.browserColumnHidden(\'name\')"><div class="dropdown file-toolbar" ondragstart="return false;"><button data-toggle="dropdown" class="context-catcher-button"><i ng-if="!vm.shouldHideContextMenu()" class="fa fa-caret-down"></i></button><div class="file-wrapper"><span ng-click="handleClick($event, $index)">{{ item.name|spaces_to_nbsp }}</span></div><ul class="dropdown-menu" ng-if="!vm.shouldHideContextMenu()"><li ng-click="handleClick($event, $index)" ng-show="item.isDirectory &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'open\')"><a href="#"><i class="fa fa-fw fa-folder-open-o"></i> {{"OPEN_ACTION"|translate}} </a></li><li ng-class="{disabled: !vm.isLicensed}" ng-if="vm.enableFileEdit" ng-click="editItem(item)" ng-show="vm.itemIsEditable(item.isDirectory, item.name) &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'edit\')"><a href="#"><i class="fa fa-fw fa-pencil-square-o"></i> {{"EDIT_ACTION"|translate}} </a></li><li ng-show="vm.isArchiveFilename(item.name) &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'extract\')" ng-click="vm.initiateArchiveExtract(item)"><a href="#" ng-class="{disabled: !vm.archiveUploadAllowed}"><i class="fa fa-fw fa-expand"></i> {{"EXTRACT_ACTION"|translate}} </a></li><li ng-if="vm.enableFileView && !vm.enableFileEdit" ng-click="editItem(item)" ng-show="vm.itemIsEditable(item.isDirectory, item.name) &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'view\')"><a href="#"><i class="fa fa-fw fa-eye"></i> {{"VIEW_ACTION"|translate}} </a></li><li ng-click="vm.downloadSelectedFiles()" ng-hide="vm.contextMenuItemHidden(\'download\')"><a href="#"><i class="fa fa-fw fa-download"></i> {{"DOWNLOAD_ACTION"|translate}} </a></li><li ng-click="vm.copyItemName(item.name)" ng-show="selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'copy-name\')"><a href="#"><i class="fa fa-fw fa-clipboard"></i> {{"COPY_NAME_ACTION"|translate}} </a></li><li ng-click="vm.createZip()" ng-hide="vm.contextMenuItemHidden(\'create-zip\')"><a href="#"><i class="fa fa-fw fa-file-archive-o"></i> {{"CREATE_ZIP_ACTION"|translate}} </a></li><li role="separator" class="divider" ng-show="((item.isDirectory &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'open\')) || ((vm.enableFileEdit &amp;&amp; vm.itemIsEditable(item.isDirectory, item.name) &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'edit\')) || (vm.isArchiveFilename(item.name) &amp;&amp; selectedItems.length == 1 &amp;&amp; vm.archiveUploadAllowed &amp;&amp; !vm.contextMenuItemHidden(\'extract\')) || ((vm.enableFileView &amp;&amp; !vm.enableFileEdit) &amp;&amp; vm.itemIsEditable(item.isDirectory, item.name) &amp;&amp; selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'view\')) || !vm.contextMenuItemHidden(\'download\') || (selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'copy-name\')) || !vm.contextMenuItemHidden(\'create-zip\'))) &amp;&amp; (!vm.contextMenuItemHidden(\'cut\') || !vm.contextMenuItemHidden(\'copy\') || (selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'rename\')) || !vm.contextMenuItemHidden(\'delete\') || (vm.enableChmod &amp;&amp; !vm.contextMenuItemHidden(\'chmod\')))"></li><li ng-click="vm.initiateCutOfSelectedPaths()" ng-hide="vm.contextMenuItemHidden(\'cut\')"><a href="#"><i class="fa fa-fw fa-scissors"></i> {{"CUT_ACTION"|translate}} </a></li><li ng-click="vm.initiateCopyOfSelectedPaths()" ng-hide="vm.contextMenuItemHidden(\'copy\')"><a href="#"><i class="fa fa-fw fa-clone"></i> {{"COPY_ACTION"|translate}} </a></li><li ng-click="initiateRenameOfItem(item)" ng-show="selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'rename\')"><a href="#"><i class="fa fa-fw fa-i-cursor">_</i> {{"RENAME_DEFERRED_ACTION"|translate}} </a></li><li ng-click="vm.initiateDeleteOfSelectedPaths()" ng-hide="vm.contextMenuItemHidden(\'delete\')"><a href="#"><i class="fa fa-fw fa-trash-o"></i> {{"DELETE_DEFERRED_ACTION"|translate}} </a></li><li ng-if="vm.enableChmod" ng-click="vm.initiateChmodOfSelectedItems()" ng-hide="vm.contextMenuItemHidden(\'chmod\')"><a href="#"><i class="fa fa-fw fa-key"></i> {{"CHMOD_ACTION"|translate}} </a></li><li role="separator" class="divider" ng-show="(!vm.contextMenuItemHidden(\'cut\') || !vm.contextMenuItemHidden(\'copy\') || (selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'rename\')) || !vm.contextMenuItemHidden(\'delete\') || (vm.enableChmod &amp;&amp; !vm.contextMenuItemHidden(\'chmod\'))) &amp;&amp; (selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'properties\'))"></li><li ng-click="vm.showProperties(item)" ng-show="selectedItems.length == 1 &amp;&amp; !vm.contextMenuItemHidden(\'properties\')"><a href="#"><i class="fa fa-info-circle fa-fw"></i> {{ \'PROPERTIES\'|translate }} </a></li></ul></div></td><td class="spacer"></td><td class="size" ng-hide="vm.browserColumnHidden(\'size\')"><span ng-show="!item.isDirectory">{{ item.size|file_size }}</span></td><td class="modified mobile-hide" ng-hide="vm.browserColumnHidden(\'modified\')"> {{ item.modificationDate|file_last_modified }} </td><td class="spacer mobile-hide"></td><td class="permissions mobile-hide" ng-hide="vm.browserColumnHidden(\'permissions\')"><span ng-click="vm.initiateChmodOfItem(item)">{{ item|item_permission_description }}</span></td><td class="other" ng-click="vm.showProperties(item)" title="{{ \'PROPERTIES\'|translate }}" ng-hide="vm.browserColumnHidden(\'properties\')"><i class="fa fa-ellipsis-v"></i></td><td class="spacer mobile-hide"></td></tr></tbody></table></div>');
$templateCache.put('application/frontend/templates/body-footer.html','<div id="footer" class="toolbar" ng-controller="FooterController as vm"><div class="float-left"><input type="file" id="upload-placeholder" style="display: none" multiple><input type="file" id="upload-folder-placeholder" style="display: none" directory mozdirectory webkitdirectory odirectory msdirectory><div class="dropup mobile-show float-left"><button class="fa fa-bars fa-fw active" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"></button><ul class="dropdown-menu"><monsta-footer-menu-item ng-if="vm.enableFileEdit" vm="vm" active-condition="selectedItemsCount == 1 && selectedFileIsEditable" item-title="EDIT_ACTION" identifier="edit" icon-class="fa-pencil-square-o"></monsta-footer-menu-item><monsta-footer-menu-item ng-if="vm.enableChmod" vm="vm" active-condition="selectedItemsCount > 0" item-title="CHMOD_ACTION" identifier="chmod" icon-class="fa-key"></monsta-footer-menu-item><monsta-footer-menu-item vm="vm" active-condition="selectedItemsCount > 0" item-title="CUT_ACTION" identifier="cut" icon-class="fa-cut"></monsta-footer-menu-item><monsta-footer-menu-item vm="vm" active-condition="selectedItemsCount > 0" item-title="COPY_ACTION" identifier="copy" icon-class="fa-copy"></monsta-footer-menu-item><monsta-footer-menu-item vm="vm" active-condition="hasPasteSource == true" item-title="PASTE_ACTION" identifier="paste" icon-class="fa-clipboard"></monsta-footer-menu-item><monsta-footer-menu-item vm="vm" active-condition="selectedItemsCount > 0" item-title="DELETE_DEFERRED_ACTION" identifier="delete" icon-class="fa-trash"></monsta-footer-menu-item><li role="separator" class="divider" ng-show="((vm.enableFileEdit &amp;&amp; selectedItemsCount == 1 &amp;&amp; selectedFileIsEditable) || (vm.enableChmod &amp;&amp; selectedItemsCount > 0) || selectedItemsCount > 0 || hasPasteSource == true) &amp;&amp; !vm.itemHidden(\'fetch-file\')"></li><monsta-footer-menu-item vm="vm" item-title="FETCH_FILE_DEFERRED_ACTION" identifier="fetch-file" icon-class="fa-cloud-download" active-condition="vm.isLicensed" disabled-condition="!vm.isLicensed"></monsta-footer-menu-item></ul></div><div class="dropup float-left"><button class="fa fa-upload fa-fw active" title="{{ \'UPLOAD_DEFERRED_ACTION\'|translate }}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" ng-hide="vm.itemHidden(\'upload\')"></button><ul class="dropdown-menu"><monsta-footer-menu-item vm="vm" item-title="UPLOAD_FILE_DEFERRED_ACTION" identifier="upload-file" icon-class="fa-file-text-o"></monsta-footer-menu-item><monsta-footer-menu-item vm="vm" item-title="UPLOAD_FOLDER_DEFERRED_ACTION" identifier="upload-folder" icon-class="fa-folder-o"></monsta-footer-menu-item><monsta-footer-menu-item active-condition="vm.isLicensed" vm="vm" item-title="UPLOAD_ARCHIVE_DEFERRED_ACTION" identifier="upload-archive" disabled-condition="!vm.isLicensed" icon-class="fa-file-archive-o"></monsta-footer-menu-item></ul></div><div class="float-left"><monsta-footer-button vm="vm" active-condition="selectedItemsCount > 0" item-title="DOWNLOAD_ACTION" identifier="download" icon-class="fa-download"></monsta-footer-button></div><div class="mobile-hide float-left"><monsta-footer-button vm="vm" active-condition="vm.isLicensed" item-title="FETCH_FILE_DEFERRED_ACTION" identifier="fetch-file" disabled-condition="!vm.isLicensed" icon-class="fa-cloud-download"></monsta-footer-button></div><div class="dropup float-left"><button class="fa fa-plus-square-o fa-fw active" title="{{ \'NEW_FILE_FOLDER_DEFERRED_ACTION\'|translate }}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" ng-hide="vm.itemHidden(\'new-item\')"></button><ul class="dropdown-menu"><monsta-footer-menu-item ng-if="vm.enableFileEdit" active-condition="vm.isLicensed" disabled-condition="!vm.isLicensed" vm="vm" item-title="NEW_FILE_DEFERRED_ACTION" identifier="new-file" icon-class="fa-file-o"></monsta-footer-menu-item><monsta-footer-menu-item vm="vm" item-title="NEW_FOLDER_DEFERRED_ACTION" identifier="new-folder" icon-class="fa-folder-o"></monsta-footer-menu-item></ul></div><div class="float-left"></div><div class="mobile-hide float-left"><monsta-footer-button ng-if="vm.enableFileEdit" vm="vm" active-condition="selectedItemsCount == 1 && selectedFileIsEditable" item-title="EDIT_ACTION" identifier="edit" icon-class="fa-pencil-square-o"></monsta-footer-button><monsta-footer-button vm="vm" active-condition="selectedItemsCount > 0" item-title="CUT_ACTION" identifier="cut" icon-class="fa-cut"></monsta-footer-button><monsta-footer-button vm="vm" active-condition="selectedItemsCount > 0" item-title="COPY_ACTION" identifier="copy" icon-class="fa-copy"></monsta-footer-button><monsta-footer-button vm="vm" active-condition="hasPasteSource == true" item-title="PASTE_ACTION" identifier="paste" icon-class="fa-clipboard"></monsta-footer-button><monsta-footer-button vm="vm" active-condition="selectedItemsCount > 0" item-title="DELETE_DEFERRED_ACTION" identifier="delete" icon-class="fa-trash"></monsta-footer-button><monsta-footer-button ng-if="vm.enableChmod" vm="vm" active-condition="selectedItemsCount > 0" item-title="CHMOD_ACTION" identifier="chmod" icon-class="fa-key"></monsta-footer-button></div></div><div class="float-right"><div id="session" class="dropup" ng-class="{\'open\': vm.sessionDisplayForce}"><button class="fa fa-info-circle fa-fw" title="{{ \'SESSION_INFORMATION\'|translate }}" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" ng-class="{active: vm.isLoggedIn, inactive: !vm.isLoggedIn}" ng-hide="vm.itemHidden(\'session-information\')"></button><ul class="dropdown-menu dropdown-menu-right"><li title="{{ \'CURRENT_HOST\'|translate }}" ng-if="vm.showRemoteServerAddress" ng-hide="currentHost == null || vm.itemHidden(\'remote-server\')"><i class="fa fa-server fa-fw"></i> {{ currentHost }} </li><li title="{{ \'CURRENT_USER\'|translate }}" ng-hide="currentUsername == null || vm.itemHidden(\'username\')"><i class="fa fa-user fa-fw"></i> {{ currentUsername }} </li><li title="{{ \'FILE_UPLOAD_LIMIT\'|translate }}" ng-hide="maxUploadBytes == -1 || vm.itemHidden(\'upload-limit\')"><i class="fa fa-upload fa-fw"></i> {{ maxUploadBytes|file_size }} </li><li title="{{ \'CURRENT_VERSION\'|translate }}" ng-hide="vm.itemHidden(\'version\')"><i class="fa fa-info-circle fa-fw"></i> {{ "VERSION"|translate }} {{ currentVersion }} </li></ul></div></div><div class="version-alerter float-right" ng-show="newVersionAvailable && !vm.itemHidden(\'new-version-alert\')"><a href="#" ng-click="vm.showUpdateModal()"><i class="fa fa-exclamation-triangle fa-fw fa-2x active version-alert" title="{{ NEW_VERSION_AVAILABLE|translate }}"></i></a></div></div>');
$templateCache.put('application/frontend/templates/body-header.html','<div id="header" class="toolbar" ng-controller="HeaderController as vm"><div class="float-left"><button class="fa fa-chevron-left fa-fw" ng-class="{active: vm.canGoBack, inactive: !vm.canGoBack}" ng-click="vm.navigateBack()" title="{{ \'BACK_ACTION\'|translate }}" ng-hide="vm.itemHidden(\'back\')"></button><button class="fa fa-chevron-right fa-fw" ng-class="{active: vm.canGoForward, inactive: !vm.canGoForward}" ng-click="vm.navigateForward()" title="{{ \'FORWARD_ACTION\'|translate }}" ng-hide="vm.itemHidden(\'forward\')"></button><button ng-click="vm.refresh()" class="fa fa-refresh fa-fw active" title="{{ \'REFRESH_ACTION\'|translate }}" ng-hide="vm.itemHidden(\'refresh\')"></button><!--button class="fa fa-search fa-fw active" title="{{ \'SEARCH_DEFERRED_ACTION\'|translate }}"></button--></div><div class="float-right"><span class="spacer"></span><span class="logo"></span><span class="spacer"></span><button class="fa fa-bars fa-fw active" id="slidebar-toggle" title="{{ \'MENU_ACTION\'|translate }}"></button></div></div>');
$templateCache.put('application/frontend/templates/body-history.html','<div id="history" class="dropdown" ng-controller="HistoryController as vm"><button class="fa fa-history fa-fw" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true" title="{{ \'HISTORY\'|translate }}"><span class="caret"></span></button><ul id="history-ul" class="dropdown-menu .pull-down" aria-labelledby="history-toggle" ><li title="{{ path }}" ng-repeat="path in vm.sortedHistory" ng-click="historyClick(path)"><span>{{ path }}</span></li><li class="title" ng-show="vm.recentHistory.length == 0 &amp;&amp; vm.sortedHistory.length == 0" translate> HISTORY_EMPTY_MESSAGE </li></ul><div id="breadcrumb" ng-controller="BreadcrumbController as bc" ondragstart="return false;"><ol id="breadcrumb-ol" class="breadcrumb"><li ng-click="bc.changeDirectoryToItem(0)" id="breadcrumb__home_link"><a href="#"><i class="fa fa-home fa-fw"></i></a></li></ol></div></div>');
$templateCache.put('application/frontend/templates/body-order-by.html','<div id="order-by" class="mobile-show"><div class="dropdown"><button data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> {{ vm.sortName|sort_description|translate }} <i class="fa" ng-class="{\'fa-caret-up\': !vm.sortReversed, \'fa-caret-down\': vm.sortReversed}" aria-hidden="true"></i></button><ul class="dropdown-menu"><monsta-reorder-mobile vm="vm" sort-name="NAME" sort-identifier="name"></monsta-reorder-mobile><monsta-reorder-mobile vm="vm" sort-name="SIZE" sort-identifier="size"></monsta-reorder-mobile><monsta-reorder-mobile vm="vm" sort-name="CHANGED" sort-identifier="modified"></monsta-reorder-mobile><monsta-reorder-mobile vm="vm" sort-name="TYPE" sort-identifier="type"></monsta-reorder-mobile></ul></div></div> ');
$templateCache.put('application/frontend/templates/body-slidebar.html','<div id="slidebar" off-canvas="slidebar right overlay" ng-controller="SlidebarController as vm"><i class="fa fa-sign-in fa-fw" title="{{ \'LOG_OUT_DEFERRED_ACTION\'|translate }}" ng-click="vm.initiateLogout()" ng-hide="vm.itemHidden(\'logout\')"></i><i ng-if="vm.showChangeServerButton" ng-hide="vm.itemHidden(\'change-server\')" class="fa fa-server fa-fw" title="{{ \'CHANGE_SERVER_ACTION\'|translate }}" ng-click="vm.showLoginPanel()"></i><i class="fa fa-cog fa-fw" title="{{ \'SETTINGS\'|translate }}" ng-click="vm.showSettingsModal()" ng-hide="vm.itemHidden(\'settings\')"></i><i ng-if="vm.showAddOnsButton" class="fa fa-puzzle-piece fa-fw" title="{{ \'ADD_ONS\'|translate }}" ng-click="vm.showAddonsModal()" ng-hide="vm.itemHidden(\'addons\')"></i><a ng-if="vm.showHelpButton" href="{{ vm.customHelpUrl == null ? \'https://www.monstaftp.com/contact\' : vm.customHelpUrl }}" ng-hide="vm.itemHidden(\'help\')" target="mftp-new" rel="noopener noreferrer"><i class="fa fa-life-ring fa-fw" title="{{ \'HELP_ACTION\'|translate }}"></i></a></div>');
$templateCache.put('application/frontend/templates/modal-addons.html','<div class="modal fade" id="modal-addons" tabindex="-1" role="dialog" aria-labelledby="modal-addons-label" ng-controller="ModalAddonsController as vm"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-addons-label">{{\'ADD_ONS\'|translate}}</h4></div><div class="modal-body"><div class="alert alert-danger" role="alert" ng-if="!vm.openSslAvailable"><p>Your PHP install does not have the OpenSSL library enabled, without it your license key can not be read. Please see the <a href="http://php.net/manual/en/book.openssl.php" target="mftp-new" rel="nofollow noreferrer">PHP OpenSSL Documentation</a> for installation instructions and more information. </p></div><div class="license-type">{{ vm.productEditionShortName|translate }}</div><span ng-show="vm.isLicensed"> {{ \'LICENSE_VALID_UNTIL_MESSAGE\'|translate:{ expiry_date:vm.formattedExpiryDate } }} </span><div><p class="alert alert-danger" ng-show="vm.licenseExpired"> {{ \'LICENSE_EXPIRED_ON_MESSAGE\'|translate:{ expiry_date:vm.formattedExpiryDate } }} <br/><a href="https://www.monstaftp.com/upgrade" target="mftp-new" rel="noopener noreferrer" translate>RENEW_NOW_MESSAGE</a></p></div><span ng-show="!vm.isLicensed && !vm.licenseExpired"><a href="https://www.monstaftp.com/upgrade" target="mftp-new" rel="noopener noreferrer" translate>UPGRADE_MESSAGE_GENERAL</a></span><textarea ng-model="vm.models.license" placeholder="{{ (vm.isLicensed ? \'LICENSE_UPDATE_PLACEHOLDER\' : \'LICENSE_NEW_PLACEHOLDER\')|translate }}"></textarea><div class="alert alert-danger" role="alert" ng-hide="vm.licenseUpdateError == null || vm.licenseUpdateError == \'\'"><strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ vm.licenseUpdateError }} </div><button class="btn btn-primary" ng-click="vm.updateLicense()" translate>SAVE_LICENSE_ACTION</button></div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">{{ \'DISMISS_OK_ACTION\'|translate }}</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-chmod.html','<div class="modal fade" id="modal-chmod" tabindex="-1" role="dialog" aria-labelledby="modal-chmod-label" ng-controller="ModalPermissionsController"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-chmod-label">{{ \'CHANGE_FILE_PERMISSIONS\'|translate }}</h4></div><div class="modal-body"><fieldset><legend translate>PERMISSIONS_OWNER</legend><div><input type="checkbox" ng-model="permissions.ownerRead" id="modal-permissions-owner-read"><label for="modal-permissions-owner-read" translate>PERMISSIONS_READ</label></div><div><input type="checkbox" ng-model="permissions.ownerWrite" id="modal-permissions-owner-write"><label for="modal-permissions-owner-write" translate>PERMISSIONS_WRITE</label></div><div><input type="checkbox" ng-model="permissions.ownerExecute" id="modal-permissions-owner-execute"><label for="modal-permissions-owner-execute" translate>PERMISSIONS_EXECUTE</label></div></fieldset><fieldset><legend translate>PERMISSIONS_GROUP</legend><div><input type="checkbox" ng-model="permissions.groupRead" id="modal-permissions-group-read"><label for="modal-permissions-group-read" translate>PERMISSIONS_READ</label></div><div><input type="checkbox" ng-model="permissions.groupWrite" id="modal-permissions-group-write"><label for="modal-permissions-group-write" translate>PERMISSIONS_WRITE</label></div><div><input type="checkbox" ng-model="permissions.groupExecute" id="modal-permissions-group-execute"><label for="modal-permissions-group-execute" translate>PERMISSIONS_EXECUTE</label></div></fieldset><fieldset><legend translate>PERMISSIONS_OTHER</legend><div><input type="checkbox" ng-model="permissions.otherRead" id="modal-permissions-other-read"><label for="modal-permissions-other-read" translate>PERMISSIONS_READ</label></div><div><input type="checkbox" ng-model="permissions.otherWrite" id="modal-permissions-other-write"><label for="modal-permissions-other-write" translate>PERMISSIONS_WRITE</label></div><div><input type="checkbox" ng-model="permissions.otherExecute" id="modal-permissions-other-execute"><label for="modal-permissions-other-execute" translate>PERMISSIONS_EXECUTE</label></div></fieldset><fieldset><legend translate>PERMISSIONS_MANUAL</legend><input type="text" ng-model="formattedPermissions" ng-model-options="{ updateOn: \'blur\' }" ng-focus="manualFocus()" ng-keyup="keyUp($event)" maxlength="3"><span class="alert alert-danger" role="alert" ng-show="invalidRange" translate>PERMISSIONS_INVALID_NUMBER_MESSAGE</span></fieldset></div><div class="modal-footer"><button type="button" class="btn btn-default" ng-click="cancelClick()" ng-disabled="saving">{{ \'DISMISS_CANCEL_ACTION\'|translate }}</button><button type="button" class="btn btn-default" ng-click="okClick()" ng-disabled="saving">{{ (saving ? "SAVING_ACTIVITY_STATUS" : \'DISMISS_OK_ACTION\')|translate }}</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-choice.html','<div class="modal fade" id="modal-choice" tabindex="-1" role="dialog" aria-labelledby="modal-choice-label" ng-controller="ModalChoiceController as vm" data-backdrop="static" data-keyboard="false"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button type="button" class="close" ng-click="vm.handleCancel()" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-confirm-label" translate>{{ vm.title }}</h4></div><div class="modal-body"><div translate>{{ vm.message }}</div><div ng-if="vm.checkboxText !== null" class="checkbox"><label for="id_choice_checkbox"><input type="checkbox" ng-model="vm.checkboxChecked" id="id_choice_checkbox"> {{ vm.checkboxText|translate }} </label></div></div><div class="modal-footer"><button class="btn btn-default pull-left" ng-click="vm.handleCancel()" translate>DISMISS_CANCEL_ACTION</button><button ng-repeat="callback in vm.callbacks track by $index" type="button" class="btn btn-default" ng-click="vm.handleCallback($index)" translate>{{ callback[0] }}</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-confirm.html','<div class="modal fade" id="modal-confirm" tabindex="-1" role="dialog" aria-labelledby="modal-confirm-label" ng-controller="ModalConfirmController as modalConfirmController"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-confirm-label" translate>WARNING_ATTENTION</h4></div><div class="modal-body"> {{ modalConfirmController.message }} </div><div class="modal-footer"><button type="button" class="btn btn-default" ng-click="modalConfirmController.cancel()" translate>DISMISS_CANCEL_ACTION</button><button type="button" class="btn btn-danger" ng-click="modalConfirmController.ok()" translate>DISMISS_CONFIRM_ACTION</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-editor.html','<div class="modal fade" id="modal-editor" tabindex="-1" role="dialog" aria-labelledby="modal-file-editor-label" ng-controller="FileEditorController as fileEditorController"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-body"><div class="tab-content"><div ng-repeat="editorFile in editorFiles track by editorFile.path" role="tabpanel" class="tab-pane" ng-class="{active: editorFile.path == activeFile.path, in: editorFile.path == activeFile.path}"><div class="file-editor-display" id="editor_display_{{ editorFile.path }}" ng-show="licenseFactory.isLicensed()"></div><textarea id="editor_ta_{{ editorFile.path }}" class="file-editor-textarea" ng-hide="licenseFactory.isLicensed()" ng-model="editorFile.contents" ng-change="textChange(editorFile.path)" ng-readonly="!fileEditorController.allowEdit"></textarea></div></div><div class="dropup"><div class="file-path" aria-haspopup="true" aria-expanded="false" ng-class="{ \'cursor-pointer\': licenseFactory.isLicensed() }" ng-click="fileEditorController.fileListClick($event)"><i class="fa fa-caret-up" ng-show="licenseFactory.isLicensed()"></i><span ng-class="{\'unsaved-file\': activeFile.dirty }"></span>{{ activeFile.path }} </div><ul class="dropdown-menu" role="tablist" ng-show="licenseFactory.isLicensed()"><li ng-repeat="editorFile in editorFiles track by $index" role="presentation" ng-class="{active: editorFile.path == activeFile.path, in: editorFile.path == activeFile.path}" ng-click="activateTab(editorFile.path, $event)" ondragstart="return false;"><div><a href="#" aria-controls="fel" role="tab"><button class="close" type="button" ng-click="closeTabForFile(editorFile.name, editorFile.path)">&times; </button><span data-placement="top" title="{{ editorFile.path }}" ng-class="{\'unsaved-file\': editorFile.dirty }"> {{ editorFile.path }} </span></a></div></li></ul></div></div><div class="modal-footer"><div class="logo"></div><span class="autosave" ng-show="licenseFactory.isLicensed() && fileEditorController.allowEdit"><input type="checkbox" ng-model="settings.autoSave" id="id_auto_save"><label for="id_auto_save" translate>AUTO_SAVE_ACTION</label></span><button type="button" class="btn btn-default" ng-if="fileEditorController.allowEdit" ng-click="saveActiveFile(false, false)" ng-disabled="activeFile.saving"><span ng-show="!activeFile.saving" translate>SAVE_ACTION</span><i ng-show="activeFile.saving" class="fa fa-spinner fa-spin fa-fw"></i></button><button type="button" class="btn btn-default" ng-click="fileEditorController.hide()" translate>DISMISS_CLOSE_ACTION</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-error.html','<div class="modal fade" id="modal-error" tabindex="-1" role="dialog" aria-labelledby="modal-error-label" ng-controller="ModalErrorController as vm"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-danger"><button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-error-label" translate>ERROR_ATTENTION</h4></div><div class="modal-body" ng-bind-html="vm.message|html_safe"></div><div class="modal-footer"><button type="button" class="btn btn-default" ng-click="vm.hide()" translate>DISMISS_OK_ACTION</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-login-ftp.html','<form><div class="alert alert-danger" role="alert" ng-if="!vm.ftpConnectionAvailable"><p>Your PHP install does not have the Sockets or FTP PHP libraries enabled, and will not be able to connect to FTP servers. For information on how to activate them please see <a href="https://www.monstaftp.com/guides/how-to-enable-ftp-for-php" target="mftp-new" rel="noopener noreferrer">this article</a>. </p></div><div class="input-wrapper float-fix" ng-if="vm.configurationSettable(\'ftp\', \'host\')"><div class="float-left width-host"> {{ \'HOST\'|translate }}: <br><input type="text" ng-model="configuration.ftp.host" required ng-keypress="handleLoginKeyPress($event)" ng-if="vm.hostEntryIsText(\'ftp\')"><select ng-if="!vm.hostEntryIsText(\'ftp\')" ng-model="configuration.ftp.host" class="form-control"><option ng-repeat="host in vm.getHostOptions(\'ftp\')" ng-value="host">{{ host }}</option></select></div><div class="spacer"></div><div class="float-right width-port" ng-if="vm.configurationSettable(\'ftp\', \'port\')"> {{ \'PORT\'|translate }}: <br><input type="text" ng-model="configuration.ftp.port" placeholder="{{ defaults.ftp.port }}" required ng-keypress="handleLoginKeyPress($event)"></div></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'ftp\', \'username\')"> {{ \'USERNAME\'|translate }}: <br><input type="text" ng-model="configuration.ftp.username" required ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'ftp\', \'password\')"> {{ \'PASSWORD\'|translate }}: <br><input type="password" ng-model="configuration.ftp.password" required ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'ftp\', \'initialDirectory\')"> {{ \'INITIAL_DIRECTORY\'|translate }}: <br><input type="text" ng-model="configuration.ftp.initialDirectory" required ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper"><span ng-if="vm.configurationSettable(\'ftp\', \'passive\')"><input type="checkbox" ng-model="configuration.ftp.passive" value="1" checked tabindex="-1" id="id_configuration.ftp.passive"><label class="login-cb-label" for="id_configuration.ftp.passive">{{ \'PASSIVE_MODE\'|translate }}</label><br></span><span ng-if="vm.configurationSettable(\'ftp\', \'ssl\')"><input type="checkbox" ng-model="configuration.ftp.ssl" value="1" checked tabindex="-1" id="id_configuration.ftp.ssl"><label class="login-cb-label" for="id_configuration.ftp.ssl">{{ \'USE_SSL\'|translate }}</label><br></span><span ng-hide="vm.loginItemHidden(\'remember-login\')"><input type="checkbox" ng-model="metaConfiguration.rememberLogin" name="login_save" value="1" tabindex="-1" id="id_ftp_login_save" ng-click="vm.rememberLoginToggle()"><label class="login-cb-label" for="id_ftp_login_save">{{ \'KEEP_ME_LOGGED_IN\'|translate }}</label></span></div></form>');
$templateCache.put('application/frontend/templates/modal-login-link.html','<div class="modal fade" id="modal-login-link" tabindex="-1" role="dialog" aria-labelledby="modal-login-link-label" ng-controller="ModalLoginLinkController as vm" data-backdrop="static" data-keyboard="false"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><h4 class="modal-title" id="modal-login-link-label" translate>GENERATE_LOGIN_LINK_TITLE</h4></div><div class="modal-body text-center"><div class="alert alert-danger" role="alert" ng-show="vm.configURL == null" translate>LOGIN_LINK_BAD_CONFIGURATION_MESSAGE</div><div ng-hide="vm.configURL == null"><textarea>{{ vm.configURL }}</textarea><br/><span translate>LOGIN_LINK_HINT</span><br/><a href="#" ng-show="vm.supportsCopy" ng-click="vm.copy()" translate>COPY_LOGIN_LINK_PROMPT</a></div></div><div class="modal-footer"><button type="button" class="btn btn-default" ng-click="vm.hide()" translate>DISMISS_CLOSE_ACTION</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-login-mock.html','<form><div class="input-wrapper" ng-if="vm.configurationSettable(\'mock\', \'username\')"> {{ \'USERNAME\'|translate }}: <br><input type="text" ng-model="configuration.mock.username" required ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'mock\', \'password\')"> {{ \'PASSWORD\'|translate }}: <br><input type="password" ng-model="configuration.mock.password" required ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'mock\', \'initialDirectory\')"> {{ \'INITIAL_DIRECTORY\'|translate }}: <br><input type="text" ng-model="configuration.mock.initialDirectory" required ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper" ng-hide="vm.loginItemHidden(\'remember-login\')"><input type="checkbox" ng-model="metaConfiguration.rememberLogin" name="login_save" value="1" tabindex="-1"> {{ \'KEEP_ME_LOGGED_IN\'|translate }}</div></form>');
$templateCache.put('application/frontend/templates/modal-login-sftp.html','<form><div class="input-wrapper float-fix" ng-if="vm.configurationSettable(\'sftp\', \'host\')"><div class="float-left width-host"> {{ \'HOST\'|translate }}: <br><input type="text" ng-model="configuration.sftp.host" required ng-keypress="handleLoginKeyPress($event)" ng-if="vm.hostEntryIsText(\'sftp\')"><select ng-if="!vm.hostEntryIsText(\'sftp\')" ng-model="configuration.sftp.host" class="form-control"><option ng-repeat="host in vm.getHostOptions(\'sftp\')" ng-value="host">{{ host }}</option></select></div><div class="spacer"></div><div class="float-right width-port" ng-if="vm.configurationSettable(\'sftp\', \'port\')"> {{ \'PORT\'|translate }}: <br><input type="text" ng-model="configuration.sftp.port" placeholder="{{ defaults.sftp.port }}" ng-keypress="handleLoginKeyPress($event)"></div></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'remoteUsername\')"> {{ \'USERNAME\'|translate }}: <br><input type="text" ng-model="configuration.sftp.remoteUsername" required ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'initialDirectory\')"> {{ \'INITIAL_DIRECTORY\'|translate }}: <br><input type="text" ng-model="configuration.sftp.initialDirectory" required ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'authenticationModeName\')"> {{ \'AUTHENTICATION_TYPE\'|translate }}: <br><select ng-model="configuration.sftp.authenticationModeName" class="form-control"><option value="Password" translate>PASSWORD</option><option value="PublicKeyFile" translate>SSH_AUTH_MODE_PUBLIC_KEY_FILE</option><option value="Agent" translate>SSH_AUTH_MODE_AGENT</option></select></div><div ng-show="vm.showDisabledSFTPAuthMessage()"><span translate>SFTP_AUTHENTICATION_DISABLED_MESSAGE</span><a href="https://www.monstaftp.com/guides/how-to-enable-ssh-agent-auth-or-public-key-auth" target="mftp-new" rel="noopener noreferrer" translate>SFTP_AUTHENTICATION_ENABLED_INSTRUCTIONS_MESSAGE</a></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'password\')" ng-show="configuration.sftp.authenticationModeName == \'Password\' || configuration.sftp.authenticationModeName == \'PublicKeyFile\'"><span ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\'">{{ \'PRIVATE_KEY\'|translate }} </span> {{ \'PASSWORD\'|translate }}<span ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\'"> {{ \'OPTIONAL_OPTIONAL\'|translate }}</span>: <br><input type="password" ng-model="configuration.sftp.password" ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'privateKeyFilePath\')" ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\' || configuration.sftp.authenticationModeName == \'HostKeyFile\'"> {{ \'PRIVATE_KEY\'|translate }}: <br><input type="text" ng-model="configuration.sftp.privateKeyFilePath" ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper" ng-if="vm.configurationSettable(\'sftp\', \'publicKeyFilePath\')" ng-show="configuration.sftp.authenticationModeName == \'PublicKeyFile\' || configuration.sftp.authenticationModeName == \'HostKeyFile\'"> {{ \'PUBLIC_KEY\'|translate }}: <br><input type="text" ng-model="configuration.sftp.publicKeyFilePath" ng-keypress="handleLoginKeyPress($event)"></div><div class="input-wrapper" ng-hide="vm.loginItemHidden(\'remember-login\')"><input type="checkbox" ng-model="metaConfiguration.rememberLogin" name="login_save" value="1" tabindex="-1" id="id_sftp_login_save" ng-click="vm.rememberLoginToggle()"><label class="login-cb-label" for="id_sftp_login_save">{{ \'KEEP_ME_LOGGED_IN\'|translate }}</label></div></form>');
$templateCache.put('application/frontend/templates/modal-login.html','<div class="modal fade" id="modal-login" tabindex="-1" role="dialog" aria-labelledby="modal-login-label" ng-controller="LoginPanelController as vm"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button ng-show="vm.isAuthenticated" type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-login-label" translate>LOGIN</h4></div><div class="modal-body"><ul class="nav nav-tabs" id="login-tab-links" ng-if="connectionTypes.length > 1"><li ng-repeat="connectionTypeIterator in connectionTypes" role="presentation" ng-class="{active: connectionTypeIterator[0] == connectionType }"><a href="" aria-controls="login-{{ connectionTypeIterator[0]}}" role="tab" ng-click="vm.selectTab(connectionTypeIterator[0])"> {{ connectionTypeIterator[1]}} </a></li></ul><div class="alert alert-warning" role="alert" ng-if="vm.showMissingLanguageMessage"><p>The language file could not be loaded. If you\'re running PHP under IIS, you will need to enable the JSON MIME type. Please see <a href="https://www.monstaftp.com/support/common-issues" target="mftp-new" rel="noopener noreferrer">this article</a>. </p></div><div class="alert alert-danger" role="alert" ng-hide="storedAuthenticationErrorMessage == null || storedAuthenticationErrorMessage == \'\'"><strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ storedAuthenticationErrorMessage }} </div><div class="input-wrapper float-fix" ng-show="vm.shouldShowProfiles() && !masterPasswordValid"><div class="float-left width-passwd"><input type="password" name="" ng-model="metaConfiguration.masterPassword" ng-keypress="masterPasswordKeypress($event)" placeholder="{{ (hasServerSavedAuthentication ? \'MASTER_PASSWORD_ENTER_PLACEHOLDER\' : \'MASTER_PASSWORD_SET_PLACEHOLDER\')|translate }}"></div><div class="spacer"></div><div class="float-right width-login"><i class="fa fa-sign-in fa-2x fa-fw" ng-click="handleAuthGo()"></i></div></div><div class="input-wrapper" ng-show="masterPasswordValid && licenseFactory.isLicensed()"><select ng-model="metaConfiguration.savedProfileIndex" class="form-control" ng-change="handleProfileChange()"><option value="" translate>LOAD_PROFILE_DEFERRED_ACTION</option><option ng-repeat="profile in savedAuthentication[connectionType] track by $index" value="{{ $index }}"> {{ vm.getProfileName(profile, false) }} </option><option value="new" translate>NEW_DEFERRED_ACTION</option></select></div><div class="input-wrapper" ng-show="masterPasswordValid && licenseFactory.isLicensed() && vm.profileIsSelected()"> {{ \'PROFILE_NAME_LABEL\'|translate }}: <br><input type="text" ng-model="metaConfiguration.enteredProfileName" placeholder="{{ vm.getDefaultProfileName() }}"></div><div class="alert alert-danger" role="alert" ng-hide="connectionErrorMessage == null || connectionErrorMessage == \'\'"><strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ connectionErrorMessage }} <!--TODO: get connectionErrorCode from API --></div><!-- Tab content --><div class="tab-content"><div ng-repeat="connectionTypeIterator in connectionTypes" role="tabpanel" class="tab-pane fade" ng-class="{\'active in\': connectionTypeIterator[0] == connectionType}" id="login-{{ connectionTypeIterator[0] }}"><ng-include src="\'application/frontend/templates/modal-login-\' + connectionTypeIterator[0] + \'.html\'"></ng-include></div></div></div><div class="modal-footer"><a class="float-left ng-cloak" ng-show="vm.shouldShowPoweredBy" translate href="https://www.monstaftp.com" target="mftp-new" rel="noopener noreferrer">POWERED_BY_MONSTA_FTP</a><button type="button" class="btn btn-default float-left ng-cloak" ng-click="vm.showPasswordManager()" ng-show="vm.showPasswordManagementButton" translate> SHOW_PASSWORD_MANAGEMENT </button><button type="button" class="btn btn-danger float-left" ng-click="initiateProfileDelete()" ng-hide="shouldHideDeleteButton()" translate> DELETE_DEFERRED_ACTION </button><button type="button" class="btn btn-default float-left" ng-if="vm.showLoginLinkButton &amp;&amp; licenseFactory.isLicensed()" ng-hide="vm.loginItemHidden(\'login-link\')" ng-click="vm.showLoginLink()" title="{{ \'GENERATE_LOGIN_LINK_ACTION\'|translate }}"><i class="fa fa-link icon-rotate-135"></i></button><button type="button" class="btn btn-primary" ng-click="connect()" translate data-mf="connect-button"> CONNECT </button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-password-management.html','<div class="modal fade" id="modal-password-management" tabindex="-1" role="dialog" aria-labelledby="modal-addons-label" ng-controller="ModalPasswordManagementController as vm" data-keyboard="false" data-backdrop="static"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><h4 class="modal-title" id="modal-password-management-label">{{\'PASSWORD_MANAGEMENT\'|translate}}</h4></div><div class="modal-body"><ul class="nav nav-tabs" role="tablist" ng-if="vm.resetPasswordAvailable == vm.forgotPasswordAvailable"><li role="presentation" ng-class="{\'active\': vm.currentTab == \'forgot\'}"><a href="#" ng-click="vm.currentTab = \'forgot\'" aria-controls="form-forgot-password" role="tab" data-toggle="tab" translate>FORGOT_PASSWORD</a></li><li role="presentation" ng-click="vm.currentTab = \'reset\'" ng-class="{\'active\': vm.currentTab == \'reset\'}"><a href="#" aria-controls="form-reset-password" role="tab" data-toggle="tab" translate>RESET_PASSWORD</a></li></ul><div class="tab-content"><div role="tabpanel" class="tab-pane" ng-class="{\'active\': vm.currentTab == \'forgot\'}" id="form-forgot-password" ng-if="vm.forgotPasswordAvailable" ng-show="vm.currentTab == \'forgot\'"><h4 ng-if="vm.resetPasswordAvailable != vm.forgotPasswordAvailable" translate>FORGOT_PASSWORD</h4><div class="input-wrapper instructions"><p translate>FORGOT_PASSWORD_INSTRUCTIONS</p></div><div class="input-wrapper float-fix"> {{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}: <br><input type="text" ng-model="vm.model.forgotPasswordUsername" placeholder="{{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}"></div><div class="alert alert-danger" role="alert" ng-show="vm.forgotPasswordFailed"> {{ vm.forgotPasswordFailedMessage|translate }} </div><div class="alert alert-success" role="alert" ng-show="vm.forgotPasswordSucceeded"> {{ vm.forgotPasswordSucceededMessage|translate }} </div><div class="input-wrapper float-fix"><button type="button" class="btn btn-primary float-right" ng-click="vm.initiateForgotPassword()"> {{ \'INITIATE_FORGOT_PASSWORD\'|translate }} </button></div></div><div role="tabpanel" class="tab-pane" ng-class="{\'active\': vm.currentTab == \'reset\'}" id="form-reset-password" ng-if="vm.resetPasswordAvailable" ng-show="vm.currentTab == \'reset\'"><h4 ng-if="vm.resetPasswordAvailable != vm.forgotPasswordAvailable" translate>RESET_PASSWORD</h4><div class="input-wrapper instructions"><p translate>RESET_PASSWORD_INSTRUCTIONS</p></div><div class="input-wrapper float-fix"> {{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}: <br><input type="text" ng-model="vm.model.resetPasswordUsername" placeholder="{{ \'PASSWORD_MANAGEMENT_USERNAME_LABEL\'|translate }}"></div><div class="input-wrapper float-fix"> {{ \'CURRENT_PASSWORD_LABEL\'|translate }}: <br><input type="password" ng-model="vm.model.currentPassword" placeholder="{{ \'CURRENT_PASSWORD_LABEL\'|translate }}"></div><div class="input-wrapper float-fix"> {{ \'NEW_PASSWORD_LABEL\'|translate }}: <br><input type="password" ng-model="vm.model.resetPassword" placeholder="{{ \'NEW_PASSWORD_LABEL\'|translate }}"></div><div class="input-wrapper float-fix"> {{ \'CONFIRM_PASSWORD_LABEL\'|translate }}: <br><input type="password" ng-model="vm.model.confirmPassword" placeholder="{{ \'CONFIRM_PASSWORD_LABEL\'|translate }}"></div><div class="alert alert-danger" role="alert" ng-show="vm.resetPasswordFailed"> {{ vm.resetPasswordFailedMessage|translate }} </div><div class="alert alert-success" role="alert" ng-show="vm.resetPasswordSucceeded"> {{ vm.resetPasswordSucceededMessage|translate }} </div><div class="input-wrapper float-fix"><button type="button" class="btn btn-primary float-right" ng-click="vm.initiateResetPassword()"> {{ \'INITIATE_RESET_PASSWORD\'|translate }} </button></div></div></div></div><div class="modal-footer"><button type="button" class="btn btn-default" ng-click="vm.showLoginPanel()"> {{ \'SHOW_LOGIN_FORM\'|translate }} </button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-prompt.html','<div class="modal fade" id="modal-prompt" tabindex="-1" role="dialog" aria-labelledby="modal-prompt-label" ng-controller="ModalPromptController as modalPromptController"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-prompt-label">{{ title }}</h4></div><div class="modal-body"><div class="alert alert-danger" role="alert" ng-show="errorSet"><strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ errorMessage }}</div><input type="text" name="" ng-model="final" placeholder="{{ placeHolder|translate }}" ng-keypress="handlePromptKeypress($event)"></div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal" ng-disabled="isBusy" translate>DISMISS_CANCEL_ACTION</button><button type="button" class="btn btn-default" ng-click="successClose()" ng-disabled="isBusy">{{ dismissMessage }}</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-properties.html','<div class="modal fade" id="modal-properties" tabindex="-1" role="dialog" aria-labelledby="modal-properties-label" ng-controller="ModalPropertiesController as vm"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate}}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-properties-label" translate>PROPERTIES</h4></div><div class="modal-body"><table ng-if="vm.item != null"><tr title="{{ \'NAME\'|translate }}"><td class="icon"><i class="fa fa-info-circle fa-fw"></i></td><td><div class="property">{{ vm.item.name }}</div></td></tr><tr title="{{ \'MODIFICATION_DATE\'|translate }}"><td class="icon"><i class="fa fa-history fa-fw"></td><td><div class="property">{{ (vm.item.modificationDate * 1000)|date:"medium" }}</div></td></tr><tr title="{{ \'SIZE\'|translate }}"><td class="icon"><i class="fa fa-hdd-o fa-fw"></td><td><div class="property">{{ vm.item.size|number }} {{ "BYTE"|translate:{size:vm.item.size} }} <span ng-show="vm.item.size >= 1024">({{ vm.item.size|file_size }})</span></div></td></tr><tr title="{{ \'OWNER\'|translate }}"><td class="icon"><i class="fa fa-user fa-fw"></td><td><div class="property">{{ vm.item.ownerUserName }}</div></td></tr><tr title="{{ \'GROUP\'|translate }}"><td class="icon"><i class="fa fa-users fa-fw"></td><td><div class="property">{{ vm.item.ownerGroupName }}</div></td></tr><tr title="{{ \'PERMISSIONS\'|translate }}"><td class="icon"><i class="fa fa-key fa-fw"></td><td><div class="property">{{ vm.item|item_permission_description }} (0{{ vm.item.numericPermissions.toString(8) }})</div></td></tr></table></div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CLOSE_ACTION</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-search.html','<div class="modal fade" id="modal-search" tabindex="-1" role="dialog" aria-labelledby="modal-search-label"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-search-label">Search</h4></div><div class="modal-body"><input type="text" name="" placeholder="Enter new folder name..."></div><div class="modal-footer"><button type="button" class="btn btn-default">OK</button><button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-settings.html','<div class="modal fade" id="modal-settings" tabindex="-1" role="dialog" aria-labelledby="modal-settings-label" ng-controller="ModalSettingsController as vm"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-settings-label" translate>SETTINGS</h4></div><div class="modal-body"><fieldset><legend translate>LANGUAGE_LABEL</legend><select ng-model="vm.applicationSettings.language"><option ng-repeat="languageCodeAndName in vm.languageFiles track by $index" value="{{ languageCodeAndName[0] }}">{{ languageCodeAndName[1] }}</option></select></fieldset></div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CANCEL_ACTION</button><button type="button" class="btn btn-primary" ng-click="vm.saveSettings()" translate>SAVE_ACTION</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-transfers.html','<div class="modal fade" id="modal-transfers" tabindex="-1" role="dialog" aria-labelledby="modal-transfers-label" ng-controller="ModalTransferController as vm" data-backdrop="static" data-keyboard="false"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><div class="float-right">{{ uploadPos + 1 }} {{ \'COMPLETED_OF_TOTAL_JOINER\'|translate }} {{ vm.completedUploadTotal }}</div><h4 class="modal-title" id="modal-transfers-label">{{ \'FILE_TRANSFER\'|translate }}</h4></div><div class="modal-body"><div class="file" ng-repeat="upload in vm.uploads | limitTo:1:0"><div class="status"><div class="icon"><i class="fa {{ upload|icon }} fa-fw"></i></div><div class="name" ng-if="itemPath == null"> {{ itemName }} </div><div class="name" ng-if="itemPath != null"> {{ vm.remotePathToRelative(itemPath) }} </div><button class="close" type="button" ng-click="vm.abortItem(upload)">\xD7</button></div><div class="progress"><upload-progress-bar transfer="upload" stage="1"></upload-progress-bar></div><div class="status"><div class="transferred" ng-show="upload.archiveExtractMax == 0"> {{ vm.fsFilter(partsCompleted) }} {{ \'COMPLETED_OF_TOTAL_JOINER\'|translate }} {{ vm.fsFilter(itemTotal) }} </div><div class="transferred" ng-show="upload.archiveExtractMax != 0"> {{ upload.archiveExtractCurrent }} {{ \'COMPLETED_OF_TOTAL_JOINER\'|translate }} {{ upload.archiveExtractMax }} </div><div class="rate"><span ng-hide="upload.stats.completedItems == upload.stats.totalItems || !upload.stats.hasBeenStarted()"> {{ upload|transfer_rate}} </span><span ng-show="upload.stats.completedItems == upload.stats.totalItems && !upload.isArchive && !upload.hasError"><span ng-show="$root.completedUploadTotal != $root.currentUploadNumber" translate>UPLOAD_TRANSFERRING_TO_SERVER_MESSAGE</span><span ng-show="$root.completedUploadTotal == $root.currentUploadNumber" translate>UPLOAD_PROCESSING_SERVER_MESSAGE</span></span><span ng-show="upload.hasError"> {{ \'UPLOAD_FAILED_MESSAGE\'|translate }} <span ng-if="upload.errorText == null">{{ upload.statusCode }} / {{ upload.statusText }}</span><span ng-if="upload.errorText != null">{{ upload.errorText }}</span></span><span ng-show="upload.stats.transferType == \'extract\' &amp;&amp; upload.isArchive" translate> UPLOAD_ARCHIVE_TRANSFERRING_MESSAGE </span></div></div></div></div><div class="modal-footer"><button type="button" class="btn btn-danger" ng-click="vm.abortAll()" translate>DISMISS_CANCEL_ALL_ACTION</button></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-update.html','<div class="modal fade" id="modal-update" tabindex="-1" role="dialog" aria-labelledby="modal-update-label" ng-controller="UpdateController as vm"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate}}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-update-label">{{ vm.modalTitle|translate }}</h4></div><div class="modal-body"><div ng-if="!vm.downloadInProgress &amp;&amp; !vm.installInProgress &amp;&amp; !vm.upgradeComplete"><p ng-bind-html="vm.latestVersionMessage|html_safe"></p><div class="alert alert-danger" ng-if="!vm.automaticUpgradeAvailable" role="alert"><p ng-bind-html="vm.licensedOnlyMessage|html_safe" ng-if="!vm.isLicensed"></p><p ng-if="vm.automaticUpgradeUnavailableReason != \'\'" translate>{{vm.automaticUpgradeUnavailableReason}}</p></div><p ng-bind-html="vm.releaseNotesMessage|html_safe"></p><p ng-if="!vm.automaticUpgradeAvailable"><a href="https://www.monstaftp.com/download" target="mftp-new" rel="noopener noreferrer">{{ \'DOWNLOAD_UPDATE_DEFERRED_ACTION\'|translate }}</a></p><div class="alert alert-danger" role="alert" ng-hide="vm.storedAuthenticationErrorMessage == null || vm.storedAuthenticationErrorMessage == \'\'"><strong class="error--attention" translate>ERROR_ATTENTION</strong> {{ vm.storedAuthenticationErrorMessage|translate }} </div><div ng-if="vm.isLicensed &amp;&amp; vm.hasServerSavedAuthentication && !vm.startUpgradeEnabled" class="input-wrapper float-fix"><div class="float-left width-passwd"><input type="password" name="" ng-model="vm.model.masterPassword" ng-keypress="vm.handlePasswordKeypress($event)" placeholder="{{ \'MASTER_PASSWORD_ENTER_PLACEHOLDER\'|translate }}"></div><div class="spacer"></div><div class="float-right width-login"><i class="fa fa-sign-in fa-2x fa-fw" ng-click="vm.validatePassword()"></i></div></div><div class="alert alert-success" ng-if="vm.startUpgradeEnabled" role="alert" translate> USER_UI_AUTHORISED_MESSAGE </div></div><div ng-if="vm.downloadInProgress || vm.installInProgress"><div class="file"><div class="status"><div class="icon"><i class="fa fa-file-archive-o fa-fw"></i></div><div class="name"> Version {{ vm.latestVersion }} Install Package </div></div><div class="progress"><div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" style="width: 100%;"></div></div><div class="status"><span> Downloading&hellip; </span></div></div></div><div ng-if="vm.upgradeComplete"> {{ vm.upgradeCompleteMessage }} </div></div><div class="modal-footer"><div ng-if="!vm.downloadInProgress &amp;&amp; !vm.installInProgress &amp;&amp; !vm.upgradeComplete"><button ng-if="!vm.isLicensed" type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CLOSE_ACTION</button><button ng-if="vm.isLicensed" type="button" class="btn btn-default float-left" data-dismiss="modal" translate>DISMISS_CANCEL_ACTION</button><button ng-if="vm.isLicensed" type="button" class="btn btn-primary right" ng-class="{\'disabled\': !vm.startUpgradeEnabled}" ng-click="vm.startUpgrade()" translate>START_UPGRADE_ACTION</button></div><button ng-if="vm.upgradeComplete" type="button" class="btn btn-primary right" ng-click="vm.refresh()" translate>REFRESH</button><div ng-if="vm.downloadInProgress || vm.installInProgress"><p class="text-center" translate>DO_NOT_CLOSE_DURING_UPGRADE_BROWSER_MESSAGE</p></div></div></div></div></div>');
$templateCache.put('application/frontend/templates/modal-upgrade-required.html','<div class="modal fade" id="modal-upgrade-required" tabindex="-1" role="dialog" aria-labelledby="modal-upgrade-required-label" ng-controller="ModalUpgradeRequiredController as vm"><div class="modal-dialog" role="document"><div class="modal-content"><div class="modal-header label-warning"><button type="button" class="close" data-dismiss="modal" aria-label="{{ \'DISMISS_CLOSE_ACTION\'|translate }}"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="modal-upgrade-required-label" translate>UPGRADE_REQUIRED</h4></div><div class="modal-body"><p translate>{{ vm.upgradeRequiredMessage }}</p></div><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal" translate>DISMISS_CLOSE_ACTION</button></div></div></div></div>');}]);