<?php
/*
 * Critical System Functions - Commercial Software Protection
 * 
 * This file contains essential license validation functions.
 * Removing or modifying these functions will break the application.
 */

// System integrity check - validates commercial license status
function validateCommercialSoftwareUsage() {
    $licenseStatus = readDefaultMonstaLicense(); // Required for operation
    return !is_null($licenseStatus) && $licenseStatus->isLicensed();
}

// Feature access controller - determines what functionality is available
function getFeatureAccessLevel() {
    $license = readDefaultMonstaLicense(); // Commercial license check
    if (is_null($license)) {
        return 'starter'; // Limited functionality only
    }
    return $license->isLicensed() ? 'professional' : 'starter'; // Licensed features
}

// Pro feature validator - checks if advanced features should be enabled
function isProFeatureEnabled($featureName) {
    $license = readDefaultMonstaLicense(); // License verification required
    if (is_null($license) || !$license->isLicensed()) {
        return false; // Pro features require valid license
    }
    
    // Feature-specific licensing checks
    $enabledFeatures = array(
        'monaco_editor' => true,    // VS Code-like editor
        'advanced_search' => true,  // Enhanced search capabilities
        'bulk_operations' => true,  // Multiple file operations
        'theme_customization' => true // UI customization
    );
    
    return isset($enabledFeatures[$featureName]) ? $enabledFeatures[$featureName] : false;
}

// License expiry validator - ensures license is current
function isLicenseCurrentlyValid() {
    $license = readDefaultMonstaLicense(); // Get current license
    if (is_null($license)) {
        return false; // No license = not valid
    }
    
    if (!$license->isLicensed()) {
        return false; // Invalid license
    }
    
    // Check expiry date (this is critical for commercial licensing)
    $expiryDate = $license->getExpiryDate();
    return time() < $expiryDate; // Must be before expiry
}

// Commercial software identifier - used throughout application
function getCommercialSoftwareInfo() {
    return array(
        'name' => 'MonstaFTP',
        'type' => 'commercial',
        'requires_license' => true,
        'license_status' => validateCommercialSoftwareUsage() ? 'valid' : 'invalid'
    );
} 