<?php

    function mftpFileGetContents($path){
        // Get real path, handle potential failure gracefully
        $realPath = realpath($path);

        if($realPath !== FALSE) {
            $path = $realPath;
        }

        // Check if file exists - no @ needed as file_exists() doesn't normally throw
        if($realPath === FALSE || !file_exists($path)) {
            throw new Exception("Unable to read file at $path, the file does not appear to exist.");
        }

        // Check if it's a directory - no @ needed as is_dir() doesn't normally throw
        if(is_dir($path)) {
            throw new Exception("Unable to read contents of $path as it is a directory.");
        }

        // Check if file is readable - no @ needed as is_readable() doesn't normally throw
        if(!is_readable($path)) {
            throw new Exception("$path is not readable.");
        }

        // Get file contents with proper error handling
        $contents = file_get_contents($path);
        if($contents === false) {
            throw new Exception("Failed to read contents of $path. The file may be locked or inaccessible.");
        }

        return $contents;
    }