<?php
    require_once(dirname(__FILE__) . "/ListItem.php");
    require_once(dirname(__FILE__) . '/IntegerPermissionSet.php');
    
    // Custom autoloader for PHPSecLib 3.x
    function loadPhpSecLib3ForListItem($className) {
        if (strpos($className, 'phpseclib3\\') === 0) {
            $relativePath = str_replace('phpseclib3\\', '', $className);
            $relativePath = str_replace('\\', '/', $relativePath);
            $filePath = dirname(__FILE__) . '/../../vendor/phpseclib/phpseclib/' . $relativePath . '.php';
            
            if (file_exists($filePath)) {
                require_once $filePath;
                return true;
            }
        }
        return false;
    }
    
    // Register the autoloader  
    spl_autoload_register('loadPhpSecLib3ForListItem');
    
    // Include PHPSecLib 3.x for constants
    require_once(dirname(__FILE__) . '/../../vendor/phpseclib/phpseclib/phpseclib/bootstrap.php');

    class PHPSecliblistItem extends ListItem {
        public function __construct($itemName, $itemStat) {
            $this->name = $itemName;

            $itemType = isset($itemStat['type']) ? $itemStat['type'] : NET_SFTP_TYPE_REGULAR;

            $this->link = $itemType == NET_SFTP_TYPE_SYMLINK;
            $this->directory = $itemType == NET_SFTP_TYPE_DIRECTORY;
            
            // PHPSecLib 3.x uses 'mode' instead of 'permissions'
            $permissionBits = isset($itemStat['mode']) ? $itemStat['mode'] & PERMISSION_BIT_MASK : 
                             (isset($itemStat['permissions']) ? $itemStat['permissions'] & PERMISSION_BIT_MASK : 0);
            
            $this->ownerPermissions = new IntegerPermissionSet($permissionBits >> 6);
            $this->groupPermissions = new IntegerPermissionSet(($permissionBits >> 3) & 0x7);
            $this->otherPermissions = new IntegerPermissionSet($permissionBits & 0x7);
            $this->linkCount = null;

            if (isset($itemStat['uname'])) {
                $this->ownerUserName = $itemStat['uname'];
            } else {
                $this->ownerUserName = isset($itemStat['uid']) ? $itemStat['uid'] : null;
            }

            if (isset($itemStat['gname'])) {
                $this->ownerGroupName = $itemStat['gname'];
            } else {
                $this->ownerGroupName = isset($itemStat['gid']) ? $itemStat['gid'] : null;
            }

            $this->size = isset($itemStat['size']) ? $itemStat['size'] : 0;
            $this->modificationDate = $itemStat['mtime'];
        }
    }