<?php

    class DateTransformer {
        private static $instance = null;
        private $monthIndexLookup;

        public static function getTransformer(): self {
            if (static::$instance === null) {
                static::$instance = new static();
            }

            return static::$instance;
        }

        private function __construct() {
            $this->monthIndexLookup = array();

            for($monthNumber = 12; $monthNumber > 0; --$monthNumber) {
                // Use date() instead of deprecated strftime() for PHP 8.1+ compatibility
                $monthShortName = date('M', mktime(0, 0, 0, $monthNumber, 1));

                $this->monthIndexLookup[$monthShortName] = $monthNumber - 1;
            }
        }

        public function monthShortNameToIndex(string $monthShortName): int {
            return $this->monthIndexLookup[$monthShortName];
        }
    }