<?php
    /**
     * This is REALLY for constants, not configuration, not intended to be edited per install
     */

    /* TODO: make this into abstract class so that we might be able to easily serialize this to JSON to make the
    "constants" available to clients */

    // Check PHP version requirement (PHP 8.1.0 or higher)
    if (PHP_VERSION_ID < 80100) {
        $requiredVersion = '8.1.0';
        $currentVersion = PHP_VERSION;
        
        // Try to send proper HTTP headers if not already sent
        if (!headers_sent()) {
            header('Content-Type: text/html; charset=utf-8');
            http_response_code(500);
        }
        
        // Display user-friendly error message
        die("
<!DOCTYPE html>
<html>
<head>
    <meta charset='utf-8'>
    <title>Monsta FTP - PHP Version Error</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f5f5f5; display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; }
        .error-container { background: white; padding: 40px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); max-width: 600px; width: 100%; }
        h1 { color: #dc3545; margin-top: 0; }
        .version-info { background: #f8f9fa; padding: 15px; border-radius: 4px; margin: 20px 0; }
        .version-info strong { color: #495057; }
        .required { color: #28a745; }
        .current { color: #dc3545; }
        p { line-height: 1.6; color: #495057; }
        .footer { margin-top: 30px; padding-top: 20px; border-top: 1px solid #dee2e6; font-size: 0.9em; color: #6c757d; }
    </style>
</head>
<body>
    <div class='error-container'>
        <h1>⚠️ PHP Version Requirement Not Met</h1>
        <p>Monsta FTP requires <strong class='required'>PHP {$requiredVersion}</strong> or higher to run.</p>
        <div class='version-info'>
            <strong>Required Version:</strong> <span class='required'>PHP {$requiredVersion}+</span><br>
            <strong>Your Current Version:</strong> <span class='current'>PHP {$currentVersion}</span>
        </div>
        <p>Please upgrade your PHP installation to version 8.1.0 or higher. Contact your hosting provider or system administrator for assistance.</p>
        <div class='footer'>
            <p><strong>Note:</strong> This requirement is due to modern PHP features and security improvements used by Monsta FTP.</p>
            <p>For installation documentation, visit: <a href='https://www.monstaftp.com/guides/' target='_blank'>https://www.monstaftp.com/guides/</a></p>
        </div>
    </div>
</body>
</html>
        ");
    }

    define("MONSTA_VERSION", trim(file_get_contents(dirname(__FILE__) . '/VERSION')));
    define("FTP_DEFAULT_PORT", 21);
    define("FTP_SYS_TYPE_UNIX", 0);
    define("FTP_SYS_TYPE_WINDOWS", 1);
    define("SFTP_DEFAULT_PORT", 22);
    define("PERMISSION_BIT_MASK", 0x1FF); // last 9 bits from mode

    define("MOCK_DEFAULT_USERNAME", "user");
    define("MOCK_DEFAULT_PASSWORD", "password");

    define("PREFERRED_CIPHER_METHODS", "aes-256-gcm|aes-256-cbc|aes-128-gcm|aes-128-cbc");

    define("PUBKEY_PATH", dirname(__FILE__) . '/resources/monsta_public.pem'); // Commercial license validation key

    define("XHR_DEFAULT_TIMEOUT_SECONDS", 30);

    define("MONSTA_DEBUG", file_exists(dirname(__FILE__) . "/DEBUG"));

    define("MONSTA_PRODUCT_EDITION_BUSINESS", 0);
    define("MONSTA_PRODUCT_EDITION_HOST", 1);

    define("USE_MFTP_LIBRARY", 0); // Disabled due to hanging issues - using regular PHP FTP functions instead
    define("USE_SECLIB_LIBRARY", 1);

    define("MFTP_UNIX_LIST_FORMAT", '/^([A-Za-z+-]{10})\s+(\d+)\s+([^ ]+)\s+([^ ]+)\s+(\d+)\s+(.{12}) (.*)$/');
    define("MFTP_WIN_LIST_FORMAT", '/^(\d+)-(\d+)-(\d+)\s+(\d+):(\d+)(A|P)M(.{22})(.*)$/');

    if (!defined("FTP_ASCII"))
        define("FTP_ASCII", 1);

    if (!defined("FTP_BINARY"))
        define("FTP_BINARY", 2);

    define("MFTP_EXTRACT_UPLOAD_TIME_LIMIT_SECONDS", 50);
    define("MFTP_UPLOAD_PROGRESS_CALLBACK_TIME_SECONDS", 30);

    define("MFTP_SESSION_KEY_PREFIX", "MFTP");
    define("MFTP_LATEST_VERSION_ARCHIVE_PATH", "https://www.monstaftp.com/downloads/mftp.php");
    define("MFTP_LATEST_VERSION_ARCHIVE_TEMP_NAME", "mftp-install.zip");
    define("MFTP_LATEST_VERSION_EXTRACT_DIR_NAME", "mftp-upgrade");
    define("MFTP_TMP_UPLOAD_TIMEOUT_SECONDS", 86400);
    define("MFTP_CAPABILITY_CACHE_TIMEOUT_SECONDS", 86400);

    function formattedSizeToBytes(string $formattedSize): int {
        $formattedSize = trim($formattedSize);
        $unit = strtolower(substr($formattedSize, -1));
        $multiplier = 1;

        switch ($unit) {
            case 'g':
                $multiplier *= 1024;
            case 'm':
                $multiplier *= 1024;
            case 'k':
                $multiplier *= 1024;
        }

        $size = $multiplier == 1 ? (int)$formattedSize : (int)substr($formattedSize, 0, strlen($formattedSize) - 1);

        return $size * $multiplier;
    }

    function includeMonstaConfig(): void {
        $configDir = dirname(__FILE__) . "/../../settings/";

        if (!defined("MONSTA_CONFIG_DIR_PATH"))
            define("MONSTA_CONFIG_DIR_PATH", $configDir);

        // Load user configuration first
        if (file_exists($configDir . "config_debug.php")) {
            require_once($configDir . "config_debug.php");
        } elseif (file_exists($configDir . "config_user.php")) {
            require_once($configDir . "config_user.php");
        } else {
            // Backward compatibility - load old config.php if new config_user.php doesn't exist
            require_once($configDir . "config.php");
        }

        // Load internal application configuration
        require_once(dirname(__FILE__) . "/config_internal.php");
    }

    $vendorPath = dirname(__FILE__) . "/vendor/";

    $vendorLibDirectories = array("phpseclib/phpseclib");

    $joinedVendorDirs = join(PATH_SEPARATOR, array_map(function ($libDir) {
        return dirname(__FILE__) . "/vendor/" . $libDir;
    }, $vendorLibDirectories));

    set_include_path(get_include_path() . PATH_SEPARATOR . $joinedVendorDirs);

    $mftpAffiliateDefinitionPath = dirname(__FILE__) . "/affiliate.php";

    if (file_exists($mftpAffiliateDefinitionPath))
        require_once($mftpAffiliateDefinitionPath);
